/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.client.HSCProfileClient;
import com.ibm.hsc.command.ControllerThread;
import com.ibm.hsc.command.HMCCommandUtils;
import com.ibm.hsc.command.HMCCommands;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.exceptions.RequiredParameterException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscConstants;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SystemConfigurationCreate
implements HMCCommands {
    private static final char GOOD_STATUS = '\u0000';
    private static final char ERROR_STATUS = '\u0001';
    private static final String LIST_DELIMITER = ",";
    private static final String AFFINITY_PARTITION_TYPE = HMCCommandUtils.AFFINITY_PARTITION_TYPE;
    private static final String PARTITION_TYPE = HMCCommandUtils.PARTITION_TYPE;
    private static final String PROFILE_TYPE = HMCCommandUtils.PROFILE_TYPE;
    private static final String SYSTEM_PROFILE_TYPE = HMCCommandUtils.SYSTEM_PROFILE_TYPE;
    private HSCCECClient hcc = null;
    private HSCClientObjectFactory hcof = null;
    private HSCLPARClient hlc = null;
    private Hashtable inParams;
    private Hashtable[] inParamsTable;
    private List desiredIOList;
    private List requiredIOList;
    private List sysProfPartitionList;
    private List sysProfProfileList;
    private String attributes;
    private String desiredCPU;
    private String desiredIO;
    private String desiredMEM;
    private String fileName;
    private String managedSystem;
    private String maximumCPU;
    private String maximumMEM;
    private String minimumCPU;
    private String minimumMEM;
    private String name;
    private String partitionName;
    private String partitionType;
    private String profilePartitionName;
    private String profileName;
    private String requiredIO;
    private String resourceType;
    private String realUser = System.getProperty("HMCRealUser.name");
    private String sniConfigMode;
    private String sniDeviceId;
    private String sniWindow;
    private String sysProfPartitionNames;
    private String sysProfProfileNames;
    private Vector recordVec;
    private Integer[] sniWindowList;
    private String[] sniDeviceIdList;
    private short bootMode = 1;
    private short serviceAuthority = 0;
    private short sfpSurveillance = 1;
    private short smallRMO = 0;
    private boolean smallRMO_specified;
    private boolean writeStatus;
    private PrintStream output;

    public SystemConfigurationCreate(boolean bl) {
        if (bl) {
            this.writeStatus = false;
            this.output = System.out;
        } else {
            this.writeStatus = true;
            this.output = ((ControllerThread)Thread.currentThread()).getOutputStream();
        }
    }

    private void initializeClients() throws HSCException {
        InetAddress inetAddress = null;
        String string = null;
        String string2 = null;
        try {
            inetAddress = InetAddress.getLocalHost();
            string2 = inetAddress.getHostName();
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
        this.hcof = HSCClientObjectFactory.getInstance(string2, null);
        if (this.resourceType.equals(AFFINITY_PARTITION_TYPE) || this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            try {
                this.hcc = this.hcof.createCECClient(this.managedSystem, false);
            }
            catch (HSCException hSCException) {
                throw new HSCException(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND"));
            }
            if (null == this.hcc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MANAGED_SYSTEM_NOT_FOUND");
                throw new HSCException(string);
            }
        }
        if (this.resourceType.equals(PROFILE_TYPE)) {
            try {
                this.hcc = this.hcof.createCECClient(this.managedSystem, false);
                this.hlc = this.hcof.createLPARClient(this.managedSystem, this.partitionName, false);
            }
            catch (HSCException hSCException) {
                throw new HSCException(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND"));
            }
            if (null == this.hlc) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PARTITION_NOT_FOUND");
                throw new HSCException(string);
            }
        }
    }

    private void checkRequiredParameters() throws HSCException, RequiredParameterException {
        String string = null;
        String string2 = null;
        Object[] objectArray = null;
        if (null == this.resourceType) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ".Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            if (null == this.managedSystem || null == this.attributes && null == this.fileName) {
                objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.FILE_PARAM + ")"};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", and " + "(" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")" + ".Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (null == this.name || null == this.sysProfPartitionNames || null == this.sysProfProfileNames) {
                objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR};
                string = "The command entered is missing required attribute values to perform operation. The required attributes for the resource type entered are " + HMCCommandUtils.NAME_ATTR + HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR + ", " + HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_ATTRIBUTES", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
        if (this.resourceType.equals(PARTITION_TYPE)) {
            if (null == this.managedSystem || null == this.attributes && null == this.fileName) {
                objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.FILE_PARAM + ")"};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", and " + "(" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")" + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (null == this.name || null == this.profileName || null == this.maximumCPU || null == this.maximumMEM || null == this.minimumCPU || null == this.minimumMEM || null == this.desiredCPU || null == this.desiredMEM) {
                objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DESIRED_MEM_ATTR};
                string = "The command entered is missing required attribute values to perform operation. The required attributes for the resource type entered are " + HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_CPU_ATTR + ", and " + HMCCommandUtils.DESIRED_MEM_ATTR + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_ATTRIBUTES", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
        if (this.resourceType.equals(AFFINITY_PARTITION_TYPE)) {
            if (null == this.managedSystem || null == this.fileName) {
                objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", and " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + HMCCommandUtils.FILE_PARAM};
                string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", and " + HMCCommandUtils.FILE_PARAM + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (null == this.partitionType) {
                objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.PARTITION_TYPE_ATTR};
                string = "The command entered is missing required attribute values to perform operation. The required attributes for the resource type entered are " + HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", and " + HMCCommandUtils.PARTITION_TYPE_ATTR + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_ATTRIBUTES", string, objectArray);
                throw new RequiredParameterException(string2);
            }
            if (null == this.recordVec || 0 == this.recordVec.size()) {
                string = "There were no records found. The creation of an affinity partition requires that at least one partition record is entered. Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NO_RECORDS_FOUND", string, null);
                throw new RequiredParameterException(string2);
            }
            Hashtable hashtable = null;
            String string3 = null;
            String string4 = null;
            int n = 0;
            while (n < this.recordVec.size()) {
                hashtable = (Hashtable)this.recordVec.get(n);
                string3 = (String)hashtable.get(HMCCommandUtils.NAME_ATTR);
                string4 = (String)hashtable.get(HMCCommandUtils.PROFILE_NAME_ATTR);
                if (null == string3 || null == string4) {
                    objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.PARTITION_TYPE_ATTR};
                    string = "The command entered is missing required attribute values to perform operation. The required attributes for the resource type entered are " + HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.PROFILE_NAME_ATTR + ", and " + HMCCommandUtils.PARTITION_TYPE_ATTR + ". Please check your entry and retry the command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_ATTRIBUTES", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
                ++n;
            }
        }
        if (this.resourceType.equals(PROFILE_TYPE) && (null == this.partitionName || null == this.managedSystem || null == this.attributes && null == this.fileName)) {
            objectArray = new String[]{HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " (" + HMCCommandUtils.ATTRIBUTE_PARAM + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.FILE_PARAM + ")"};
            string = "The command entered is either missing a required parameter or a parameter value is invalid. The required parameters for this command is " + HMCCommandUtils.RESOURCE_TYPE_PARAM + ", " + HMCCommandUtils.MANAGED_SYSTEM_PARAM + ", " + HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM + ", and " + "(" + HMCCommandUtils.ATTRIBUTE_PARAM + " or " + HMCCommandUtils.FILE_PARAM + ")" + ". Please check your entry and retry the command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS", string, objectArray);
            throw new RequiredParameterException(string2);
        }
    }

    private void validateParameterValues() throws RequiredParameterException, HSCException {
        int n;
        int n2;
        int n3;
        Hashtable hashtable = null;
        Integer n4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object[] objectArray = null;
        int n5 = 0;
        int n6 = 0;
        if (!(this.resourceType == null || this.resourceType.equals(AFFINITY_PARTITION_TYPE) || this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(PROFILE_TYPE) || this.resourceType.equals(SYSTEM_PROFILE_TYPE))) {
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
            throw new RequiredParameterException(string2);
        }
        if (!(this.partitionType == null || this.partitionType.equals("1") || this.partitionType.equals("2") || this.partitionType.equals("3"))) {
            string = "The partition type entered is invalid. Please retry commmand.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_PARTITION_TYPE_INVALID", string, null);
            throw new RequiredParameterException(string2);
        }
        if (this.partitionType != null) {
            Vector vector = null;
            vector = this.hcc.getPPARInfo(this.partitionType, false);
            if (this.recordVec.size() != vector.size()) {
                objectArray = new String[]{new Integer(vector.size()).toString()};
                string = "There is an invalid number of records. With the partition_type entered, there must be only {0} partition records entered. Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_INVALID_RECORD_NUMBER", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
        hashtable = this.hcc.getSystemData();
        short s = ((Integer)hashtable.get("State")).shortValue();
        short s2 = ((Integer)hashtable.get("Mode")).shortValue();
        if (s != 1 && !this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            string = "The resource cannot be changed because the managed system is not in the ready state. Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NOT_IN_READY_STATE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (s2 == HscConstants.SMP_MODE.shortValue() && !this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            string = "The resource cannot be created because the managed system is in SMP mode. Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_CHANGE_IN_SMP_MODE", string, objectArray);
            throw new RequiredParameterException(string2);
        }
        if (this.resourceType.equals(PROFILE_TYPE)) {
            if (this.hlc.getPartitionType() > 1) {
                if (this.desiredCPU != null || this.desiredMEM != null || this.minimumMEM != null || this.maximumMEM != null || this.minimumCPU != null || this.maximumCPU != null) {
                    objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DESIRED_MEM_ATTR};
                    string = "An error occurred while attempting to create an affinity partition profile. The " + HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", and " + HMCCommandUtils.MAXIMUM_CPU_ATTR + " are not valid attributes for creating" + " an affinity partition. Please retry this command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_ALPAR_ILLEGAL_ATTRIBUTES", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
            } else if (null == this.name || null == this.maximumCPU || null == this.maximumMEM || null == this.minimumCPU || null == this.minimumMEM || null == this.desiredCPU || null == this.desiredMEM) {
                objectArray = new String[]{HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.DESIRED_MEM_ATTR};
                string = "The command entered is missing required attribute values to perform operation. The required attributes for the resource type entered are " + HMCCommandUtils.NAME_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_CPU_ATTR + ", and " + HMCCommandUtils.DESIRED_MEM_ATTR + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_ATTRIBUTES", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
        Integer n7 = (Integer)hashtable.get("InstalledMemory");
        Integer n8 = (Integer)hashtable.get("InstalledCPUCount");
        Integer n9 = (Integer)hashtable.get("LmbSize");
        boolean bl = false;
        if (this.name != null && this.name.length() > 31) {
            objectArray = new String[]{HMCCommandUtils.NAME_ATTR};
            string = "The value " + HMCCommandUtils.NAME_ATTR + " cannot be larger than 31 characters" + ". Please retry command.";
            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NAME_MORE_THAN_31_CHAR", string, objectArray);
            throw new RequiredParameterException(string);
        }
        if (this.maximumMEM != null || this.minimumMEM != null || this.desiredMEM != null || this.maximumCPU != null || this.minimumCPU != null || this.desiredCPU != null) {
            if (this.maximumMEM != null && n7 < Integer.parseInt(this.maximumMEM)) {
                bl = true;
            }
            if (this.minimumMEM != null && n7 < Integer.parseInt(this.minimumMEM)) {
                bl = true;
            }
            if (this.desiredMEM != null && n7 < Integer.parseInt(this.desiredMEM)) {
                bl = true;
            }
            if (this.maximumCPU != null && n8 < Integer.parseInt(this.maximumCPU)) {
                bl = true;
            }
            if (this.minimumCPU != null && n8 < Integer.parseInt(this.minimumCPU)) {
                bl = true;
            }
            if (this.desiredCPU != null && n8 < Integer.parseInt(this.desiredCPU)) {
                bl = true;
            }
            if (bl) {
                objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR", "or", null) + " " + HMCCommandUtils.DESIRED_CPU_ATTR};
                string = "An error occurred while trying to perform this command. The " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + HMCCommandUtils.DESIRED_MEM_ATTR + ", " + HMCCommandUtils.MINIMUM_CPU_ATTR + ", " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ", or " + HMCCommandUtils.DESIRED_CPU_ATTR + " exceeds the actual memory and processor count of the managed system." + " Please make the appropriate changes and retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MEM_CPU_EXCEEDS_CEC", string, objectArray);
                throw new RequiredParameterException(string2);
            }
        }
        if (this.minimumCPU != null && this.maximumCPU != null) {
            int n10 = 0;
            int n11 = 0;
            n10 = Integer.parseInt(this.maximumCPU);
            if (n10 < (n11 = Integer.parseInt(this.minimumCPU))) {
                objectArray = new String[]{HMCCommandUtils.MINIMUM_CPU_ATTR, HMCCommandUtils.MAXIMUM_CPU_ATTR};
                string = "The value of the " + HMCCommandUtils.MINIMUM_CPU_ATTR + " must be less than the value of " + HMCCommandUtils.MAXIMUM_CPU_ATTR + ". Please check your entry and retry the command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_MEM_TOO_LOW", string, objectArray);
                throw new RequiredParameterException(string);
            }
            if (this.desiredMEM != null && this.minimumMEM != null && this.maximumMEM != null) {
                n3 = Integer.parseInt(this.minimumMEM);
                n2 = Integer.parseInt(this.maximumMEM);
                n = Integer.parseInt(this.desiredMEM);
                if (n2 < n3) {
                    string = "The value of the minimum memory setting must be less than the value of the maximum memory setting. Please check your entry and retry the command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_MEM_MUST_BE_LESS_THAN_MAX", string, null);
                    throw new RequiredParameterException(string2);
                }
                int n12 = n9;
                if (n3 % n12 != 0 || n2 % n12 != 0 || n % n12 != 0) {
                    string = "The value of " + HMCCommandUtils.MINIMUM_MEM_ATTR + ", " + HMCCommandUtils.MAXIMUM_MEM_ATTR + ", " + " and " + HMCCommandUtils.DESIRED_MEM_ATTR + " must be a multiple of the logical memory block of the system (" + n12 + "). Please check your entry and retry the command.";
                    objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR, HMCCommandUtils.MAXIMUM_MEM_ATTR, HMCCommandUtils.DESIRED_MEM_ATTR, n9.toString()};
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MULTIPLE_OF_LMB", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
                objectArray = new String[]{HMCCommandUtils.MINIMUM_MEM_ATTR, HMCCommandUtils.MAXIMUM_MEM_ATTR};
                if (this.smallRMO_specified && this.smallRMO == 2 && n2 / 64 < n3) {
                    string = "The value of the " + HMCCommandUtils.MAXIMUM_MEM_ATTR + " must be at least 64X the " + HMCCommandUtils.MINIMUM_MEM_ATTR + ". Please check your entry and retry the command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_MIN_MEM_TOO_LOW", string, objectArray);
                    System.err.println(string2);
                }
            }
            if (this.sysProfPartitionList != null) {
                n3 = 0;
                while (n3 < this.sysProfPartitionList.size()) {
                    n5 = 0;
                    string4 = (String)this.sysProfPartitionList.get(n3);
                    n2 = 0;
                    while (n2 < this.sysProfPartitionList.size()) {
                        string3 = (String)this.sysProfPartitionList.get(n2);
                        if (string3.equals(string4) && ++n5 > 1) {
                            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SAME_PROFILE_PARTITION");
                            throw new RequiredParameterException(string2);
                        }
                        ++n2;
                    }
                    ++n3;
                }
            }
            if (this.sniWindowList != null) {
                n3 = 0;
                while (n3 < this.sniWindowList.length) {
                    n4 = this.sniWindowList[n3];
                    n6 = n4 % 16;
                    if (n6 > 0) {
                        string = "All values for sni_windows must be a multiple of 16. Please check your entry and retry the command.";
                        string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SNI_WINDOWS");
                        throw new RequiredParameterException(string2);
                    }
                    ++n3;
                }
            }
            if (this.bootMode == HMCCommandUtils.INVALID_BOOT_MODE) {
                objectArray = new String[]{HMCCommandUtils.BOOT_MODE_ATTR, HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.SMS_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.STANDBY_BOOT_MODE_STR};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.BOOT_MODE_ATTR + " are " + HMCCommandUtils.NORMAL_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR + ", " + HMCCommandUtils.SMS_BOOT_MODE_STR + ", " + HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR + ", " + HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR + ", and " + HMCCommandUtils.STANDBY_BOOT_MODE_STR + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
            if (this.serviceAuthority != HMCCommandUtils.SERVICE_AUTHORITY_OFF && this.serviceAuthority != HMCCommandUtils.SERVICE_AUTHORITY_ON) {
                objectArray = new String[]{HMCCommandUtils.SERVICE_AUTHORITY_ATTR, HMCCommandUtils.SERVICE_AUTHORITY_OFF + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SERVICE_AUTHORITY_ON};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SERVICE_AUTHORITY_ATTR + " are " + HMCCommandUtils.SERVICE_AUTHORITY_OFF + " and " + HMCCommandUtils.SERVICE_AUTHORITY_ON + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
            if (this.sfpSurveillance != HMCCommandUtils.SFP_SURVEILLANCE_OFF && this.sfpSurveillance != HMCCommandUtils.SFP_SURVEILLANCE_ON) {
                objectArray = new String[]{HMCCommandUtils.SFP_SURVEILLANCE_ATTR, HMCCommandUtils.SFP_SURVEILLANCE_OFF + " " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + HMCCommandUtils.SFP_SURVEILLANCE_ON};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SFP_SURVEILLANCE_ATTR + " are " + HMCCommandUtils.SFP_SURVEILLANCE_OFF + " and " + HMCCommandUtils.SFP_SURVEILLANCE_ON + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
            if (this.smallRMO_specified && this.smallRMO != 1 && this.smallRMO != 2) {
                objectArray = new String[]{HMCCommandUtils.SMALL_RMO_ATTR, "1 " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "AND", "and", null) + " " + 2};
                string = "There is an invalid parameter value. The valid values for " + HMCCommandUtils.SMALL_RMO_ATTR + " are " + 1 + " and " + 2 + ". Please retry command.";
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_GENERAL_INVALID_PARAMETER_VALUE", string, objectArray);
                throw new RequiredParameterException(string);
            }
        }
        if (this.resourceType.equals(HMCCommandUtils.AFFINITY_PARTITION_TYPE)) {
            Hashtable hashtable2 = null;
            String string5 = null;
            n3 = 0;
            while (n3 < this.recordVec.size()) {
                hashtable2 = (Hashtable)this.recordVec.get(n3);
                string5 = (String)hashtable2.get(HMCCommandUtils.NAME_ATTR);
                if (string5 != null && string5.length() > 31) {
                    objectArray = new String[]{HMCCommandUtils.NAME_ATTR};
                    string = "The value of " + HMCCommandUtils.NAME_ATTR + " cannot be larger than 31 characters" + ". Please retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NAME_MORE_THAN_31_CHAR", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
                string5 = (String)hashtable2.get(HMCCommandUtils.PROFILE_NAME_ATTR);
                if (string5 != null && string5.length() > 31) {
                    objectArray = new String[]{HMCCommandUtils.PROFILE_NAME_ATTR};
                    string = "The value of " + HMCCommandUtils.PROFILE_NAME_ATTR + " cannot be larger than 31 characters" + ". Please retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_NAME_MORE_THAN_31_CHAR", string, objectArray);
                    throw new RequiredParameterException(string2);
                }
                ++n3;
            }
        }
        if (this.resourceType.equals(HMCCommandUtils.SYSTEM_PROFILE_TYPE)) {
            HSCProfileClient hSCProfileClient = null;
            String string6 = null;
            String string7 = null;
            n2 = 0;
            while (n2 < this.sysProfProfileList.size()) {
                string6 = (String)this.sysProfProfileList.get(n2);
                string7 = (String)this.sysProfPartitionList.get(n2);
                hSCProfileClient = this.hcof.createProfileClient(this.managedSystem, string7, string6, false);
                if (hSCProfileClient == null) {
                    string = "An error ocured when trying to perform this command. A partition or a partition profile was not found. When creating a system profile, all partition profiles must exist. Please make changes and retry command.";
                    string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYS_PROF_PART_PROF_NOT_FOUND", string, null);
                    throw new RequiredParameterException(string);
                }
                ++n2;
            }
        }
        String string8 = null;
        String string9 = null;
        if (this.resourceType.equals(PARTITION_TYPE) || this.resourceType.equals(PROFILE_TYPE)) {
            boolean bl2 = false;
            if (this.requiredIOList != null && this.desiredIOList != null) {
                n2 = 0;
                while (n2 < this.requiredIOList.size()) {
                    string9 = (String)this.requiredIOList.get(n2);
                    n = 0;
                    while (n < this.desiredIOList.size()) {
                        string8 = (String)this.desiredIOList.get(n);
                        if (this.requiredIOList.equals(this.desiredIOList)) {
                            string = "There cannot be matching required I/O resources or desired I/O resources added or changed in the partition or profile. Please retry command.";
                            string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_SYS_PROF_IO_MATCHING", string, null);
                            throw new RequiredParameterException(string2);
                        }
                        ++n;
                    }
                    ++n2;
                }
            }
        }
    }

    private Hashtable[] buildALPARInputParams() throws RequiredParameterException, HSCException {
        Object var1_1 = null;
        Hashtable hashtable = null;
        Short s = null;
        Object var4_4 = null;
        String string = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var13_13 = null;
        Object var14_14 = null;
        Object var15_15 = null;
        StringTokenizer stringTokenizer = null;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        Object var21_21 = null;
        Object var22_22 = null;
        String[] stringArray5 = null;
        int n = 0;
        int n2 = -1;
        if (this.recordVec != null && this.recordVec.size() != 0) {
            this.inParamsTable = new Hashtable[this.recordVec.size()];
            int n3 = 0;
            while (n3 < this.recordVec.size()) {
                hashtable = (Hashtable)this.recordVec.get(n3);
                this.inParamsTable[n3] = new Hashtable();
                this.inParamsTable[n3].put("PartitionType", this.partitionType);
                string4 = (String)hashtable.get(HMCCommandUtils.BOOT_MODE_ATTR);
                if (null != string4) {
                    if (string4.equals(HMCCommandUtils.NORMAL_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.NORMAL_BOOT_MODE;
                    }
                    if (string4.equals(HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE;
                    }
                    if (string4.equals(HMCCommandUtils.SMS_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.SMS_BOOT_MODE;
                    }
                    if (string4.equals(HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE;
                    }
                    if (string4.equals(HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE;
                    }
                    if (string4.equals(HMCCommandUtils.STANDBY_BOOT_MODE_STR)) {
                        this.bootMode = HMCCommandUtils.STANDBY_BOOT_MODE;
                    }
                }
                this.inParamsTable[n3].put("BootMode", new Short(this.bootMode));
                string4 = (String)hashtable.get(HMCCommandUtils.NAME_ATTR);
                if (null != string4) {
                    this.inParamsTable[n3].put("PartitionName", string4);
                }
                if (null != (string4 = (String)hashtable.get(HMCCommandUtils.PHYSICAL_LOCATION_ATTR))) {
                    this.inParamsTable[n3].put("PhysicalLocationCode", string4);
                }
                if (null != (string4 = (String)hashtable.get(HMCCommandUtils.PROFILE_NAME_ATTR))) {
                    this.inParamsTable[n3].put("UserDefinedName", string4);
                }
                s = null != (string4 = (String)hashtable.get(HMCCommandUtils.SERVICE_AUTHORITY_ATTR)) ? new Short(string4) : new Short(this.serviceAuthority);
                this.inParamsTable[n3].put("ServiceAuthority", s);
                string4 = (String)hashtable.get(HMCCommandUtils.SMALL_RMO_ATTR);
                s = null != string4 ? new Short(string4) : (this.smallRMO_specified ? new Short(this.smallRMO) : new Short(1));
                this.inParamsTable[n3].put("RMOSize", s);
                string4 = (String)hashtable.get(HMCCommandUtils.SFP_SURVEILLANCE_ATTR);
                s = null != string4 ? new Short(string4) : new Short(this.sfpSurveillance);
                this.inParamsTable[n3].put("SFPSurveillance", s);
                string4 = (String)hashtable.get(HMCCommandUtils.SNI_CONFIG_MODE_ATTR);
                if (null != string4) {
                    this.inParamsTable[n3].put("SNIConfigMode", new Short(string4));
                }
                if ((string4 = (String)hashtable.get(HMCCommandUtils.SNI_DEVICE_ID_ATTR)) != null) {
                    stringTokenizer = new StringTokenizer(string4, LIST_DELIMITER);
                    stringArray5 = new String[stringTokenizer.countTokens()];
                    n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            stringArray5[n] = stringTokenizer.nextToken();
                            ++n;
                        }
                        catch (Exception exception) {
                            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                            throw new RequiredParameterException(string);
                        }
                    }
                    this.inParamsTable[n3].put("SNIDeviceID", stringArray5);
                }
                if ((string4 = (String)hashtable.get(HMCCommandUtils.SNI_WINDOW_ATTR)) != null) {
                    stringTokenizer = new StringTokenizer(string4, LIST_DELIMITER);
                    stringArray5 = new String[stringTokenizer.countTokens()];
                    n = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        try {
                            stringArray5[n] = stringTokenizer.nextToken();
                            ++n;
                        }
                        catch (Exception exception) {
                            string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                            throw new RequiredParameterException(string);
                        }
                    }
                    this.inParamsTable[n3].put("SNIWindows", stringArray5);
                }
                Hashtable hashtable2 = null;
                string3 = (String)hashtable.get(HMCCommandUtils.REQUIRED_IO_ATTR);
                string2 = (String)hashtable.get(HMCCommandUtils.DESIRED_IO_ATTR);
                if (string3 != null) {
                    this.requiredIOList = HMCCommandUtils.parseList(string3, LIST_DELIMITER);
                    hashtable2 = this.hcc.convertPhyLocsToSlotDrawerIds(this.requiredIOList);
                    stringArray3 = (String[])hashtable2.get("IODrawer");
                    stringArray4 = (String[])hashtable2.get("IOSlots");
                }
                if (string2 != null) {
                    this.desiredIOList = HMCCommandUtils.parseList(string2, LIST_DELIMITER);
                    hashtable2 = this.hcc.convertPhyLocsToSlotDrawerIds(this.desiredIOList);
                    stringArray = (String[])hashtable2.get("IODrawer");
                    stringArray2 = (String[])hashtable2.get("IOSlots");
                }
                if (stringArray3 != null) {
                    this.inParamsTable[n3].put("RequiredDrawer", stringArray3);
                }
                if (stringArray4 != null) {
                    this.inParamsTable[n3].put("RequiredSlot", stringArray4);
                }
                if (stringArray != null) {
                    this.inParamsTable[n3].put("DesiredDrawer", stringArray);
                }
                if (stringArray2 != null) {
                    this.inParamsTable[n3].put("DesiredSlot", stringArray2);
                }
                ++n3;
            }
        }
        return this.inParamsTable;
    }

    private Hashtable buildInputParams() throws HSCException {
        Object var1_1 = null;
        Integer n = null;
        Object var3_3 = null;
        Object var4_4 = null;
        this.inParams = new Hashtable();
        this.inParams.put("Action", "createProfile");
        this.inParams.put("BootMode", new Short(this.bootMode));
        this.inParams.put("ServiceAuthority", new Short(this.serviceAuthority));
        this.inParams.put("RMOSize", new Short(this.smallRMO));
        this.inParams.put("SFPSurveillance", new Short(this.sfpSurveillance));
        if (this.requiredIOList != null) {
            this.inParams.put("Required_IO", this.requiredIOList);
        }
        if (this.desiredIOList != null) {
            this.inParams.put("Desired_IO", this.desiredIOList);
        }
        if (this.name != null) {
            this.inParams.put("UserDefinedName", this.name);
        }
        if (this.resourceType.equals(PROFILE_TYPE)) {
            this.inParams.put("PartitionName", this.hlc.getIntName());
        }
        if (this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            this.inParams.put("ManagedSystem", this.hcc.getIntName());
        }
        if (this.resourceType.equals(PARTITION_TYPE)) {
            if (this.partitionType != null) {
                n = new Integer(this.partitionType);
                this.inParams.put("PartitionType", this.partitionType);
            }
            this.inParams.put("PartitionName", this.name);
        } else if (this.resourceType.equals(AFFINITY_PARTITION_TYPE) && this.partitionType != null) {
            n = new Integer(this.partitionType);
            this.inParams.put("PartitionType", this.partitionType);
        }
        if (this.desiredCPU != null) {
            n = new Integer(this.desiredCPU);
            this.inParams.put("DesiredCPUCount", n);
        }
        if (this.maximumCPU != null) {
            n = new Integer(this.maximumCPU);
            this.inParams.put("MaximumCPUCount", n);
        }
        if (this.minimumCPU != null) {
            n = new Integer(this.minimumCPU);
            this.inParams.put("MinimumCPUCount", n);
        }
        if (this.desiredMEM != null) {
            n = new Integer(this.desiredMEM);
            this.inParams.put("DesiredMemoryMB", n);
        }
        if (this.maximumMEM != null) {
            n = new Integer(this.maximumMEM);
            this.inParams.put("MaximumMemoryMB", n);
        }
        if (this.minimumMEM != null) {
            n = new Integer(this.minimumMEM);
            this.inParams.put("MinimumMemoryMB", n);
        }
        if (this.profileName != null) {
            this.inParams.put("ProfileName", this.profileName);
        }
        if (this.profilePartitionName != null) {
            this.inParams.put("PartitionName", this.profilePartitionName);
        }
        if (this.sniConfigMode != null) {
            this.inParams.put("SNIConfigMode", new Short(this.sniConfigMode));
        } else {
            this.sniConfigMode = "0";
            this.inParams.put("SNIConfigMode", new Short("0"));
        }
        if (this.sniDeviceIdList != null) {
            this.inParams.put("SNIDeviceID", this.sniDeviceIdList);
        }
        if (this.sniWindowList != null) {
            this.inParams.put("SNIWindows", this.sniWindowList);
        }
        if (this.sysProfPartitionList != null) {
            this.inParams.put("SysProfPartitionList", this.sysProfPartitionList);
        }
        if (this.sysProfProfileList != null) {
            this.inParams.put("SysProfProfileList", this.sysProfProfileList);
        }
        return this.inParams;
    }

    private void doCreatePartition() throws HSCException {
        String string;
        this.hcc.createPartition(this.inParams);
        String[] stringArray = new String[3];
        stringArray[0] = string = (String)this.inParams.get("UserDefinedName");
        HSCLPARClient hSCLPARClient = this.hcof.createLPARClient(this.managedSystem, string, false);
        String string2 = hSCLPARClient.getIntName();
        stringArray[1] = string2.substring(0, 3);
        stringArray[2] = this.managedSystem;
        String string3 = "Logical Partition " + stringArray[0] + " with ID " + stringArray[1] + " is created in CEC " + stringArray[2];
        HSCLogUtils.logSystemEvent((short)2002, string3, stringArray, this.realUser);
    }

    private void doCreateAffinityPartition() throws HSCException {
        Object object;
        String string;
        this.hcc.createAffinityPartition(this.inParamsTable, this.partitionType);
        String[] stringArray = new String[3];
        String string2 = "";
        Vector<HSCLPARClient> vector = new Vector<HSCLPARClient>();
        int n = 0;
        while (n < this.inParamsTable.length) {
            string = (String)this.inParamsTable[n].get("PartitionName");
            if (string != null) {
                string2 = string2 + " " + string;
                vector.addElement(this.hcof.createLPARClient(this.managedSystem, string, false));
            }
            ++n;
        }
        stringArray[0] = string2;
        string = "";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (HSCLPARClient)enumeration.nextElement();
            String string3 = object.getIntName();
            string = string + " " + string3.substring(0, 3);
        }
        stringArray[1] = string;
        stringArray[2] = this.managedSystem;
        object = "Affinity Logical Partition " + stringArray[0] + " with ID " + stringArray[1] + " is created in CEC " + stringArray[2];
        HSCLogUtils.logSystemEvent((short)2002, (String)object, stringArray, this.realUser);
    }

    private void doCreateLPARProfile() throws HSCException {
        this.hlc.createProfile(this.inParams);
        String[] stringArray = new String[]{(String)this.inParams.get("UserDefinedName"), this.managedSystem};
        String string = "Profile " + stringArray[0] + " is created in CEC " + stringArray[1];
        HSCLogUtils.logSystemEvent((short)2027, string, stringArray, this.realUser);
    }

    private void doCreateSystemProfile() throws HSCException {
        this.hcc.createProfile(this.inParams);
        String[] stringArray = new String[]{(String)this.inParams.get("UserDefinedName"), this.managedSystem};
        String string = "System Profile " + stringArray[0] + " is created in CEC " + stringArray[1];
        HSCLogUtils.logSystemEvent((short)2031, string, stringArray, this.realUser);
    }

    public void performCommand() throws HSCException, RequiredParameterException {
        this.checkRequiredParameters();
        this.initializeClients();
        this.validateParameterValues();
        if (this.resourceType.equals(AFFINITY_PARTITION_TYPE)) {
            this.buildALPARInputParams();
            this.doCreateAffinityPartition();
        } else if (this.resourceType.equals(PARTITION_TYPE)) {
            this.buildInputParams();
            this.doCreatePartition();
        } else if (this.resourceType.equals(PROFILE_TYPE)) {
            this.buildInputParams();
            this.doCreateLPARProfile();
        } else if (this.resourceType.equals(SYSTEM_PROFILE_TYPE)) {
            this.buildInputParams();
            this.doCreateSystemProfile();
        }
    }

    public void mapParameters(HashMap hashMap) throws RequiredParameterException {
        Hashtable hashtable;
        Hashtable hashtable2 = null;
        Integer n = null;
        Object var4_4 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        StringTokenizer stringTokenizer = null;
        int n2 = 0;
        this.attributes = (String)hashMap.get(HMCCommandUtils.ATTRIBUTE_PARAM);
        this.fileName = (String)hashMap.get(HMCCommandUtils.FILE_PARAM);
        this.managedSystem = (String)hashMap.get(HMCCommandUtils.MANAGED_SYSTEM_PARAM);
        this.partitionName = (String)hashMap.get(HMCCommandUtils.SOURCE_PARTITION_NAME_PARAM);
        this.resourceType = (String)hashMap.get(HMCCommandUtils.RESOURCE_TYPE_PARAM);
        if (this.fileName != null && this.resourceType != null) {
            if (this.resourceType.equals(AFFINITY_PARTITION_TYPE)) {
                hashtable = null;
                hashtable = HMCCommandUtils.parseInputFile(this.fileName, true);
                hashtable2 = (Hashtable)hashtable.get(HMCCommandUtils.ATTRIBUTES_KEY);
                this.recordVec = (Vector)hashtable.get(HMCCommandUtils.RECORDS_KEY);
            } else {
                hashtable2 = HMCCommandUtils.parseInputFile(this.fileName, false);
            }
        } else if (this.attributes != null) {
            hashtable2 = HMCCommandUtils.parseAttributes(this.attributes);
        }
        if ((this.attributes != null || this.fileName != null) && hashtable2 != null) {
            this.desiredCPU = (String)hashtable2.get(HMCCommandUtils.DESIRED_CPU_ATTR);
            this.desiredMEM = (String)hashtable2.get(HMCCommandUtils.DESIRED_MEM_ATTR);
            this.maximumCPU = (String)hashtable2.get(HMCCommandUtils.MAXIMUM_CPU_ATTR);
            this.maximumMEM = (String)hashtable2.get(HMCCommandUtils.MAXIMUM_MEM_ATTR);
            this.minimumCPU = (String)hashtable2.get(HMCCommandUtils.MINIMUM_CPU_ATTR);
            this.minimumMEM = (String)hashtable2.get(HMCCommandUtils.MINIMUM_MEM_ATTR);
            this.name = (String)hashtable2.get(HMCCommandUtils.NAME_ATTR);
            this.partitionType = (String)hashtable2.get(HMCCommandUtils.PARTITION_TYPE_ATTR);
            this.profileName = (String)hashtable2.get(HMCCommandUtils.PROFILE_NAME_ATTR);
            this.profilePartitionName = (String)hashtable2.get(HMCCommandUtils.PROFILE_PARTITION_NAME_ATTR);
            this.sniConfigMode = (String)hashtable2.get(HMCCommandUtils.SNI_CONFIG_MODE_ATTR);
            this.sniDeviceId = (String)hashtable2.get(HMCCommandUtils.SNI_DEVICE_ID_ATTR);
            this.sniWindow = (String)hashtable2.get(HMCCommandUtils.SNI_WINDOW_ATTR);
            string2 = (String)hashtable2.get(HMCCommandUtils.DESIRED_IO_ATTR);
            string4 = (String)hashtable2.get(HMCCommandUtils.REQUIRED_IO_ATTR);
            this.sysProfPartitionNames = (String)hashtable2.get(HMCCommandUtils.SYS_PROF_PARTITION_NAMES_ATTR);
            this.sysProfProfileNames = (String)hashtable2.get(HMCCommandUtils.SYS_PROF_PROFILE_NAMES_ATTR);
            string5 = (String)hashtable2.get(HMCCommandUtils.SERVICE_AUTHORITY_ATTR);
            if (string5 != null) {
                this.serviceAuthority = Short.parseShort(string5);
            }
            if ((string6 = (String)hashtable2.get(HMCCommandUtils.SFP_SURVEILLANCE_ATTR)) != null) {
                this.sfpSurveillance = Short.parseShort(string6);
            }
            if ((string7 = (String)hashtable2.get(HMCCommandUtils.SMALL_RMO_ATTR)) != null) {
                this.smallRMO = Short.parseShort(string7);
                this.smallRMO_specified = true;
            }
            if ((string = (String)hashtable2.get(HMCCommandUtils.BOOT_MODE_ATTR)) != null) {
                this.bootMode = string.equals(HMCCommandUtils.NORMAL_BOOT_MODE_STR) ? HMCCommandUtils.NORMAL_BOOT_MODE : (string.equals(HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_DEFAULT_BOOT_MODE : (string.equals(HMCCommandUtils.SMS_BOOT_MODE_STR) ? HMCCommandUtils.SMS_BOOT_MODE : (string.equals(HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE_STR) ? HMCCommandUtils.OPEN_FIRMWARE_BOOT_MODE : (string.equals(HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE_STR) ? HMCCommandUtils.DIAGNOSTIC_STORED_BOOT_MODE : (string.equals(HMCCommandUtils.STANDBY_BOOT_MODE_STR) ? HMCCommandUtils.STANDBY_BOOT_MODE : HMCCommandUtils.INVALID_BOOT_MODE)))));
            }
        }
        hashtable = null;
        if (string2 != null) {
            this.desiredIOList = HMCCommandUtils.parseList(string2, LIST_DELIMITER);
        }
        if (string4 != null) {
            this.requiredIOList = HMCCommandUtils.parseList(string4, LIST_DELIMITER);
        }
        if (this.sniDeviceId != null) {
            stringTokenizer = new StringTokenizer(this.sniDeviceId, LIST_DELIMITER);
            n = null;
            this.sniDeviceIdList = new String[stringTokenizer.countTokens()];
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.sniDeviceIdList[n2] = stringTokenizer.nextToken();
                    ++n2;
                }
                catch (Exception exception) {
                    string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                    throw new RequiredParameterException(string3);
                }
            }
        }
        if (this.sniWindow != null) {
            stringTokenizer = new StringTokenizer(this.sniWindow, LIST_DELIMITER);
            this.sniWindowList = new Integer[stringTokenizer.countTokens()];
            n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    this.sniWindowList[n2] = n = new Integer(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    string3 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_INVALID_PARAMETERS");
                    throw new RequiredParameterException(string3);
                }
                ++n2;
            }
        }
        if (this.sysProfPartitionNames != null) {
            this.sysProfPartitionList = HMCCommandUtils.parseList(this.sysProfPartitionNames, LIST_DELIMITER);
        }
        if (this.sysProfProfileNames != null) {
            this.sysProfProfileList = HMCCommandUtils.parseList(this.sysProfProfileNames, LIST_DELIMITER);
        }
        if (IDebug.enabled()) {
            System.out.println("Bootmode = " + this.bootMode);
            System.out.println("DesiredCPU = " + this.desiredCPU);
            System.out.println("DesiredIO = " + string2);
            System.out.println("DesiredMEM = " + this.desiredMEM);
            System.out.println("Name = " + this.name);
            System.out.println("Max CPU = " + this.maximumCPU);
            System.out.println("Max Mem = " + this.maximumMEM);
            System.out.println("Min CPU = " + this.minimumCPU);
            System.out.println("Min MEM = " + this.minimumMEM);
            System.out.println("ProfileName = " + this.profileName);
            System.out.println("ProfilePartitionName = " + this.profilePartitionName);
            System.out.println("RequiredIO = " + string4);
            System.out.println("serviceAuthority = " + this.serviceAuthority);
            System.out.println("sfp = " + this.sfpSurveillance);
            System.out.println("smallRMO = " + this.smallRMO);
            System.out.println("sniConfigMode = " + this.sniConfigMode);
            System.out.println("sniWindow = " + this.sniWindow);
            System.out.println("sniDeviceId = " + this.sniDeviceId);
            System.out.println("sysProfPartitionNames = " + this.sysProfPartitionNames);
            System.out.println("sysProfProfileNames = " + this.sysProfProfileNames);
            if (this.desiredIOList != null) {
                n2 = 0;
                while (n2 < this.desiredIOList.size()) {
                    System.out.println("DesiredIO[" + n2 + "] = " + this.desiredIOList.get(n2));
                    ++n2;
                }
            }
            if (this.requiredIOList != null) {
                n2 = 0;
                while (n2 < this.requiredIOList.size()) {
                    System.out.println("RequiredIO[" + n2 + "] = " + this.requiredIOList.get(n2));
                    ++n2;
                }
            }
            if (this.sniDeviceIdList != null) {
                n2 = 0;
                while (n2 < this.sniDeviceIdList.length) {
                    System.out.println("sniDeviceIdList[" + n2 + "] = " + this.sniDeviceIdList[n2]);
                    ++n2;
                }
            }
            if (this.sniWindowList != null) {
                n2 = 0;
                while (n2 < this.sniWindowList.length) {
                    System.out.println("sniWindowList[" + n2 + "] = " + this.sniWindowList[n2]);
                    ++n2;
                }
            }
            if (this.sysProfPartitionList != null) {
                n2 = 0;
                while (n2 < this.sysProfPartitionList.size()) {
                    System.out.println("sysProfPartition[" + n2 + "] = " + (String)this.sysProfPartitionList.get(n2));
                    ++n2;
                }
            }
        }
    }

    public void printResults() {
    }

    public void printHelp() {
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MAKE_SYSTEM_CONFIGURATION_HELP"));
    }

    public static void main(String[] stringArray) {
        SystemConfigurationCreate systemConfigurationCreate = new SystemConfigurationCreate(true);
        int n = systemConfigurationCreate.process(stringArray);
        System.exit(n);
    }

    public static void entryMethod(String[] stringArray) {
        SystemConfigurationCreate systemConfigurationCreate = new SystemConfigurationCreate(false);
        systemConfigurationCreate.process(stringArray);
    }

    private int process(String[] stringArray) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            String string2 = null;
            if (0 == stringArray.length) {
                this.printHelp();
            }
            int n = 0;
            while (n < stringArray.length) {
                string2 = stringArray[n];
                arrayList.add(string2);
                if (string2.equals(HMCCommandUtils.HELP_PARAM)) {
                    this.printHelp();
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                HashMap hashMap = HMCCommandUtils.parseParameters(arrayList);
                this.mapParameters(hashMap);
                this.performCommand();
            }
        }
        catch (HSCException hSCException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                hSCException.printStackTrace(this.output);
            }
            if ((string = hSCException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR");
            }
            this.output.println(string);
            return 1;
        }
        catch (RequiredParameterException requiredParameterException) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                requiredParameterException.printStackTrace(this.output);
            }
            if ((string = requiredParameterException.getMessage()) == null) {
                string = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR_REQUIRED_PARAMETERS");
            }
            this.output.println(string);
            return 1;
        }
        catch (Exception exception) {
            if (this.writeStatus) {
                this.writeStatus = false;
                this.output.print('\u0001');
            }
            if (IDebug.enabled()) {
                exception.printStackTrace(this.output);
            }
            this.output.println(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "COMMAND_LINE_ERROR"));
            return 1;
        }
        if (this.writeStatus) {
            this.writeStatus = false;
            this.output.print('\u0000');
        }
        return 0;
    }
}

